export function Name() {
	return 'fifine AM9';
  }
  export function VendorId() {
	return 12610;
  }
  export function ProductId() {
	return 40969;
  }
  // export function VendorId() {
  //   return 6700;
  // }
  // export function ProductId() {
  //   return 23366;
  // }
//   export function Size() {
//     return [12, 1];
//   }
  export function Type() {
	return 'Microphone';
  }
  export function Publisher() {
	return 'Feifan';
  }
  export function Fps() {
	return 10;
  }
  
  export function Validate() {
	return { type: 0, usage: 21930, usagePage: 65280 };
  }
  
  function SetupChannels() {
	device.SetLedLimit(12);
	for (let i = 0; i < ChannelArray.length; i++) {
	  device.addChannel(ChannelArray[i][0], ChannelArray[i][1],'id_'+i);
	}
  }
  export function Initialize() {
	SetupChannels();
  }
  
  var ChannelArray = [['fifine AM9', 12]];
  function sendColors(name) {
	let shutdown = false;
	var color;
  
	if (shutdown) {
	  color = hexToRgb(shutdownColor);
	} else {
	  color = device.channel(name).getColors('Inline', 'RGB');
	}
	color = color.map(item => item.reverse())
	return color;
  }
  
  export function Render() {
	
	// let packet = [0xa5, 0x5a, 0xfe, 0x02, 0x00, 0x05, 0x16];
	let packet = [0xa5, 0x5a, 0xfe, 0x26, 0x0b, 0x0c];
	// console.log(JSON.parse(JSON.stringify()))
	for (let i = 0; i < ChannelArray.length; i++) {

	  device.channel(ChannelArray[i][0]).LedLimit(ChannelArray[i][1]);
let ceshi1 = sendColors(ChannelArray[i][0]).reverse()

	  packet = packet.concat(ceshi1);
	//   packet = packet.concat(sendColors(ChannelArray[i][0]).reverse());
	}

	packet = packet.flat();
	packet.push(0x16);
	device.write(packet, 64);
  }
  
  export function Shutdown() {
	// let packet = [0x07, 0xf7, 0x05, 0x05, 0xf4, 0xff, 0xff, 0xff];
	let packet = [0x07, 0xf7, 0x05, 0x05, 0xff, 0xff, 0xff];
	// device.write(packet, 8);
  }
  
  function hexToRgb(hex) {
	let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
	let colors = [];
	colors[0] = parseInt(result[1], 16);
	colors[1] = parseInt(result[2], 16);
	colors[2] = parseInt(result[3], 16);
  
	return colors;
  }
  
  export function sendAM9Eq(eqData, type) {
	
	const data = [0xa5, 0x5a, 0xfe, 0x66, 0x0a];
	// EQ设置为音乐通道还是麦克风通道
	data.push(type == 'Music' ? 0x00 : 0x01)
	//   for (let i = 0; i < 10; i++) {
	//     data.push(...[0x01, 0x00, 0x01, 0x00, 0x2c, 0x01, 0xcd, 0x02, 0x00, 0x00]);
	//   }
	for (let i = 0; i < eqData.length; i++) {
		const gainParams = eqData[i][3] >= 0 ? eqData[i][3] * 256 : 65536 + eqData[i][3] * 256;
		const gain = Number(gainParams.toFixed(0));
		const q = Number((eqData[i][2] * 1024).toFixed(0));
		data.push(0x01, 0x00); // enable
		data.push(...changeAM9Data(eqData[i][0])); // type
		data.push(...changeAM9Data(eqData[i][1])); // F0
		
		data.push(...changeAM9Data(q)); // Q
		data.push(...changeAM9Data(gain)); // gain
		
	}
	for (let i = eqData.length; i < 10; i++) {
	  data.push(0x00, 0x00, 0x01, 0x00, 0x2c, 0x01, 0xcd, 0x02, 0x00, 0x00);
	}
	data.push(0x16);
  
	//   const data = [0xa5, 0x5a, 0xfe, 0x02, 0x00, 0x04, 0x16];
	device.writeAM9Eq(data, 256, 0);
  }
  const changeAM9Data = (number) => {
	const str = number.toString(16).padStart(4, '0');
	const arr = [];
	arr.push(parseInt(str.slice(2, 4), 16));
	arr.push(parseInt(str.slice(0, 2), 16));
	return arr;
  };
  
  export function ControllableParameters() {
	return [
	  { property: 'shutdownColor', group: 'lighting', label: 'Shutdown Color', min: '0', max: '360', type: 'color', default: '#009bde' },
	  { property: 'LightingMode', group: 'lighting', label: 'Lighting Mode', type: 'combobox', values: ['Canvas', 'Forced'], default: 'Canvas' },
	  { property: 'forcedColor', group: 'lighting', label: 'Forced Color', min: '0', max: '360', type: 'color', default: '#009bde' }
	];
  }
  